///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _MAINDLG_CPP
#define _MAINDLG_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <CommCtrl.H>
#include <PrSht.H>

#include "../Resources/Resource.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "../../SharedSource/NSWFL.H"
#include "../../SharedClasses/CMemPool/CMemPool.H"
#include "../../SharedSource/Common.H"

#include "../Source/Entry.H"
#include "../Source/Routines.H"
#include "../Source/Replication.H"

#include "../Dialogs/MainDlg.H"
#include "../Dialogs/SplashDlg.H"
#include "../Dialogs/ReplicationDlg.H"
#include "../Dialogs/PendingTrans.H"
#include "../Dialogs/AskPwd.H"
#include "../Dialogs/SetNewGUIPwd.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//---------------------(Variable Declarations)
HWND hMainDialog = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK MainDialog(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    static HWND hStaticFrame = NULL;
    static HWND hTotalConnects = NULL;
    static HWND hWarnings = NULL;
    static HWND hErrors = NULL;

	static HMENU hSystemMenu = NULL;

	static int iLastWidth = 0;
	static int iLastHeight = 0;

	//--------------------------------------------------------------------------

    if(uMsg == WM_INITDIALOG)
    {
		if(gdwGUIPWHashSz > 0)
		{
			if(DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_ASKPWD), hWnd, (DLGPROC)AskPwdDialog) != 100)
			{
				EndDialog(hWnd, 0);
				return TRUE;
			}
		}

		hSystemMenu = GetSystemMenu(hWnd, FALSE);
        AppendMenu(hSystemMenu, MF_SEPARATOR, 0, 0);
        AppendMenu(hSystemMenu, MF_STRING, 1000, "About");

        SendMessage(hWnd, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)gsTitleCaption);
        SendMessage(hWnd, WM_SETICON, TRUE, (LPARAM) LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN)) );

        MDI.hMenu      = LoadMenu(ghAppInstance, MAKEINTRESOURCE(IDR_MAINMENU));
		MDI.hStatusBar = CreateStatusWindow(WS_CHILD|WS_VISIBLE, "Transactions: 0/s", hWnd, 1);
        MDI.hLogList   = GetDlgItem(hWnd, IDC_LOGLIST);
		hStaticFrame   = GetDlgItem(hWnd, IDC_STATICFRAME);
        hTotalConnects = GetDlgItem(hWnd, IDC_TOTALCONNECTS);
        hWarnings      = GetDlgItem(hWnd, IDC_WARNINGS);
        hErrors        = GetDlgItem(hWnd, IDC_ERRORS);

        int Widths[] = {200, -1};

        SendMessage(MDI.hStatusBar, (UINT)SB_SETPARTS, (WPARAM)2, (LPARAM)&Widths);

		SetMenu(hWnd, MDI.hMenu);

		RECT WindowRECT;
        GetClientRect(hWnd, &WindowRECT);
        MoveWindow(MDI.hLogList, 0, 86, WindowRECT.right, ((WindowRECT.bottom-20) - 86), TRUE);
        MoveWindow(hStaticFrame, 0, 0, WindowRECT.right, 85, TRUE);

		Set_Long(hTotalConnects, gdwTotalConnects);
        Set_Long(hWarnings, gdwWarningCount);
        Set_Long(hErrors, gdwErrorCount);

		SetTimer(hWnd, 0, 500, NULL);
		SetTimer(hWnd, 1, 1000, NULL);

		if(gMem.IsDebug())
		{
			SetTimer(hWnd, 2, 1000, NULL);
		}

		CenterWindow(hWnd);

        if(gbDebugMode)
			CheckMenuItem(MDI.hMenu, ID_ADVANCED_DEBUGMODE, MF_BYCOMMAND|MF_CHECKED);
		else CheckMenuItem(MDI.hMenu, ID_ADVANCED_DEBUGMODE, MF_BYCOMMAND|MF_UNCHECKED);

		if(gbShowSplashScreen)
		{
			DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_SPLASH), hWnd, (DLGPROC)SplashDialog);
		}

		if(gbAutoConnect)
		{
			SendMessage(hWnd, WM_COMMAND, ID_CONNECTION_CONNECTNOW, 0);
		}

		if(!IsClientConfigured(true))
		{
			WriteSysLogEx("Cannot connect to the SQL-Exchange server: Not configured.", EVENT_WARN);
		}

        hMainDialog = hWnd;
		gbIsMainDialogOpen = true;

		return TRUE;
    }

    //--------------------------------------------------------------------------

    if(uMsg == WM_COMMAND)
    {
		if(wParam == ID_SETTINGS_SETPASSWORD)
        {
			DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_SETGUIPWD), hWnd, (DLGPROC)SetGUIPwdDialog);
			return TRUE;
		}

		if(wParam == ID_ADVANCED_PENDING_TRANSACTIONS)
        {
			DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_PENDINGTRANS), hWnd, (DLGPROC)PendingTransDialog);
			return TRUE;
		}

		if(wParam == ID_ADVANCED_DEBUGMODE)
        {
            if(gbDebugMode)
            {
                CheckMenuItem(MDI.hMenu, ID_ADVANCED_DEBUGMODE, MF_BYCOMMAND|MF_UNCHECKED);
                gbDebugMode = false;
            }
            else{
                CheckMenuItem(MDI.hMenu, ID_ADVANCED_DEBUGMODE, MF_BYCOMMAND|MF_CHECKED);
                gbDebugMode = true;
            }
            return TRUE;
        }

		if(wParam == ID_SETTINGS_GENERATEREPLICATIONSQL)
        {
			CStatusDlg MyStatDlg;

			MyStatDlg.Load(NULL, "Creating replications.", IDI_MAIN, false);
			ShowWindow(hWnd, SW_HIDE);
			ShowWindow(hMainDialog, SW_HIDE);
			MyStatDlg.Show();

			if(GenerateReplicationScripts(&MyStatDlg, gsReplicationDB, gsDefaultDBO, true))
			{
				MyStatDlg.SetText("Done generating the replication SQL.");
			}
			else MyStatDlg.SetText("An error occured while generating the replication SQL.");

			MyStatDlg.SetButtonText("Ok");

			MyStatDlg.EnableButton();

			while(MyStatDlg.IsDlgVisible())
			{
				Sleep(1);
			}

			MyStatDlg.Unload();

			ShowWindow(hWnd, SW_SHOW);

			SetForegroundWindow(hWnd);

			return TRUE;
        }

		if(wParam == ID_SETTINGS_REPLICATION)
        {
			ShowWindow(hWnd, SW_HIDE);
			DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_REPLICATION), hWnd, (DLGPROC)ReplicationDialog);
			ShowWindow(hWnd, SW_SHOW);

			return TRUE;
        }
        
		if(wParam == ID_CONNECTION_CONNECTNOW)
        {
			WriteSysLogEx("Opening manual connection to server.", EVENT_NONE);
			gbConnectNow = true;
            return TRUE;
        }

        if(wParam == ID_CONNECTION_FORCEDISCONNECT)
        {
			if(gServer.bcConnected[CCI.iThisClient])
			{
				if(MessageBox(hWnd, "Disconnecting during an active session may result in data loss.\r\nAre you sure you want to forcfully disconnect from the server?", gsTitleCaption, MB_YESNO|MB_APPLMODAL|MB_ICONQUESTION) == IDYES)
				{
	                gServer.bcDisconnect[CCI.iThisClient] = true;
					return 0;
				}
			}
			else{
				MessageBox(hWnd, "No connection is currently active.", gsTitleCaption, MB_APPLMODAL|MB_ICONASTERISK);
			}

            return TRUE;
        }

        if(wParam == ID_SETTINGS_GENERALSETTINGS)
		{
			LaunchConfigDlg(hWnd);
			return TRUE;
        }

        if(wParam == ID_HELP_ABOUT)
		{
            _AboutDialogInfo ADI;
    
            ADI.DisplayIcon  = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN));
            ADI.TitleCaption = gsTitleCaption;
            ADI.FileVersion  = gsFileVersion;
            ADI.BuildDate    = __DATE__;
            ADI.BuildTime    = __TIME__;
            ADI.CopyRight    = gsAppCopyRight;
            ADI.OwnerHandle  = hWnd;

            NetLogo(&ADI);
            return TRUE;
        }

        if(wParam == ID_FILE_CLOSEDLG)
        {
			gbIsMainDialogOpen = false;
			EndDialog(hWnd,0);
			DestroyWindow(hWnd);
            return TRUE;
        }

		return FALSE;
    }

	if(uMsg == WM_SIZE)
    {
		int nWidth = LOWORD(lParam);
		int nHeight = HIWORD(lParam);

		if(nWidth < 300)
			nWidth = iLastWidth;

		if(nHeight < 150)
			nHeight = iLastHeight;

		iLastWidth = nWidth;
		iLastHeight = nHeight;

		MoveWindow(MDI.hLogList, 0, 86, nWidth, (nHeight-20) - 86, TRUE);
		MoveWindow(MDI.hStatusBar, nWidth-20, nHeight-20, nWidth, nHeight, TRUE);
		MoveWindow(hStaticFrame, 0, 0, nWidth, 85, TRUE);

		return FALSE;//Return false of we process WM_SIZE.
    }

	//--------------------------------------------------------------------------

	if(uMsg == WM_TIMER)
    {
        if(wParam == 0)
		{
			Set_Long(hTotalConnects, gdwTotalConnects);
			Set_Long(hWarnings, gdwWarningCount);
			Set_Long(hErrors, gdwErrorCount);
		}
		else if(wParam == 1)
		{
			char sText[255];

			EnterCriticalSection(&csTransPerSecond);
			sprintf_s(sText, sizeof(sText), "Transactions: %d/s", giTransProcessed);
			giTransProcessed = 0;
			LeaveCriticalSection(&csTransPerSecond);

			SendMessage(MDI.hStatusBar, (UINT)SB_SETTEXT, (WPARAM)0, (LPARAM) sText);
		}
		#ifdef _DEBUG_MEMPOOL
			else if(wParam == 2)
			{
				char sText[255];
				sprintf_s(sText, sizeof(sText), "Allocations: %d/%d", gMem.GetMemAllocationCount(), gMem.GetSlotAllocationCount());
				SendMessage(MDI.hStatusBar, (UINT)SB_SETTEXT, (WPARAM)1, (LPARAM) sText);
			}
		#endif

		return true;
    }

	//--------------------------------------------------------------------------

	if(uMsg == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(hWnd, &ThisPS);

        // Any painting should be done here

        EndPaint(hWnd, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(uMsg == WM_SYSCOMMAND) // Received A System Menu Message
    {
        if(LOWORD(wParam) == 1000)
        {
            _AboutDialogInfo ADI;
    
            ADI.DisplayIcon  = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN));
            ADI.TitleCaption = gsTitleCaption;
            ADI.FileVersion  = gsFileVersion;
            ADI.BuildDate    = __DATE__;
            ADI.BuildTime    = __TIME__;
            ADI.CopyRight    = gsAppCopyRight;
            ADI.OwnerHandle  = hWnd;

            NetLogo(&ADI);
            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

    if(uMsg == WM_CLOSE) 
    {
	    KillTimer(hWnd, 0);
		KillTimer(hWnd, 1);
        gbIsMainDialogOpen = false;
        EndDialog(hWnd,0);
        DestroyWindow(hWnd);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

